var Cal;
var samplePageObj = {
  // 샘플 타이틀
  title: '달력 사용',
  subtitle: '시트 내부/외부에서 시트의 달력을 사용해 봅니다.',
  // 샘플 설명
  desc: '시트 내에 Date 컬럼이나, 외부에서 시트가 제공하는 달력 컨트롤을 사용하실 수 있습니다.'
    + '<br>이벤트를 통해 특정 기간안에서 일자를 선택하게 제한하거나, 드래그를 통해 여러일자를 선택하실 수도 있습니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0,
      FitWidth: true
    },
    LeftCols: [
      {
        Type: 'Int',
        Width: 80,
        Align: 'Center',
        Name: 'SEQ'
      }
    ],
    Cols: [
      {
        Header: '사업코드',
        Type: 'Text',
        Width: 80,
        Name: 'DIV_CD',
        Align: 'Center'
      }, // 사업부문
      {
        Header: '수주번호',
        Type: 'Text',
        Width: 120,
        Name: 'ORDER_NUM',
        Align: 'Center'
      }, // 수주번호
      {
        Header: '고객ID',
        Type: 'Text',
        Width: 120,
        Name: 'CUST_CD',
        Align: 'Center'
      }, // 수주처코드
      {
        Header: '고객명',
        Type: 'Text',
        Width: 150,
        Name: 'CUST_NM',
        TextColor: '#0000FF'
      }, // 수주처명
      {
        Header: '수주명',
        Type: 'Text',
        Width: 350,
        Name: 'ORDER_NM'
      }, // 수주명
      {
        Header: '수주일',
        Type: 'Date',
        Width: 120,
        Name: 'ORDER_DATE',
        DataFormat: 'yyyy-MM-dd',
        EditFormat: 'yyyyMMdd'
      }, // 수주일
      {
        Header: '납기일',
        Type: 'Date',
        Width: 120,
        Name: 'DUE_DATE',
        DataFormat: 'yyyy-MM-dd',
        EditFormat: 'yyyyMMdd',
        Color: '#FFDD77'
      }, // 납기일
      {
        Header: '검수일',
        Type: 'Date',
        Width: 120,
        Name: 'DTDY31',
        DataFormat: 'yyyy-MM-dd',
        EditFormat: 'yyyyMMdd'
      }, // 검수일
      {
        Header: '고유번호',
        Type: 'Text',
        MinWidth: 15,
        Name: 'NOCS31',
        Align: 'Center'
      }, // 원가번호
      {
        Header: '마감여부',
        Type: 'Bool',
        Width: 70,
        Name: 'ORDER_CLOSE_YN'
      } // 수주마감
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div>'
    + '<input type=\'text\'  id=\'normal_calendar\' class=\'mgr10\'><button type=\'button\' class=\'mgr10\'  onclick=\'sampleBtn(this)\' inp=\'normal_calendar\'>일반</button>'
    + ' <input type=\'text\'  id=\'drag_calendar\' class=\'mgr10\' style=\'width:170px\'><button type=\'button\' class=\'mgr10\'  onclick=\'sampleBtn(this)\' inp=\'drag_calendar\'>드래그 선택</button><hr>'
    + ' <input type=\'text\'  id=\'block_calendar\' class=\'mgr10\' style=\'width:170px\'><button type=\'button\' class=\'mgr10\'  onclick=\'sampleBtn(this)\' inp=\'block_calendar\'>특정기간내 선택</button>'
    + ' <input type=\'text\'  id=\'spday_calendar\' class=\'mgr10\' style=\'width:170px\'><button type=\'button\' class=\'mgr10\'  onclick=\'sampleBtn(this)\' inp=\'spday_calendar\'>특정일자표시</button>'
    + '</div>'
    + '<div>'
    + ' <input type=\'text\' name=\'fromID\' id=\'fromID\' DATE=\'FromYMD\' DATE_REF=\'toID\' class=\'mgr10\'/><button class=\'calbtn\' onclick=\'IBSheet.v7.IBS_FromToCalendar("fromID","yyyy-MM-dd")\' class=\'mgr10\'>달력</button>'
    + ' ~ <input type=\'text\' name=\'toID\' id=\'toID\' DATE=\'ToYMD\' DATE_REF=\'fromID\' class=\'mgr10\'/><button class=\'calbtn\' onclick=\'IBSheet.v7.IBS_FromToCalendar("toID","yyyy-MM-dd")\' class=\'mgr10\'>달력</button>'
    + '</div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
    window.Cal = null;
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    var btnObj = arguments[0];
    var optionCal = {};
    var value = null;

    // 달력내에 날짜 선택시
    function callBack(pickdate) {
      // pickdate는 1549897200000  와 같은 timeStamp 형태의 숫자가 넘어옴
      var inp = btnObj.getAttribute('inp');
      var format = 'yyyy/MM/dd';
      var str = '';

      if (pickdate !== '') {
        if (isNaN(pickdate)) {
          // 기간 데이터
          var pd = pickdate.split(';');

          for (var i = 0; i < pd.length; i++) {
            if (pd[i].indexOf('~') > -1) {
              var rdate = pd[i].split('~');

              pd[i] = IBSheet.dateToString(parseInt(rdate[0], 10), format) + '~' + IBSheet.dateToString(parseInt(rdate[1], 10), format);
            } else { pd[i] = IBSheet.dateToString(parseInt(pd[i], 10), format); }
          }
          str = pd.join(';');
        } else {
          // 단일 일자
          str = IBSheet.dateToString(pickdate, format);
        }
      }

      document.getElementById(inp).value = str;
    }

    // 달력 위치 정보
    var pos = { Tag: btnObj.getAttribute('inp') };

    if (btnObj.innerText === '일반') {
      var date = null;

      // input에 값이 있는 경우 그 날짜로 달력이 보이도록 설정
      if (document.getElementById(btnObj.getAttribute('inp')).value !== '') {
        date = new Date(document.getElementById(btnObj.getAttribute('inp')).value);
      }
      optionCal = {
        Date: date,
        Buttons: 3, // 달력 밑에 나타날 버튼을 설정 1 - Today, 2 - Clear, 4 - Ok, 8 - Yesterday
        Texts: {
          Ok: '선택',
          Clear: '지우기',
          Cancel: '취소',
          Today: '오늘',
          Yesterday: '어제',
          EmptyTip: '공백'
        },
      };

      if (Cal) { Cal.Close(); }
      Cal = IBSheet.showCalendar(optionCal, pos, callBack);
    } else if (btnObj.innerText === '드래그 선택') {
      if (document.getElementById(btnObj.getAttribute('inp')).value) {
        value = document.getElementById(btnObj.getAttribute('inp')).value.split(';').map(val => {
          if (val.indexOf('~')) {
            return val.split('~').map(val => { return new Date(val).getTime(); }).join('~');
          }

          return new Date(val).getTime();
        }).join(';');
      }

      optionCal = {
        Date: value,
        Range: 1, // 드래그를 통한 영역 설정
        Buttons: 5, // 달력 밑에 나타날 버튼을 설정 1 - Today, 2 - Clear, 4 - Ok, 8 - Yesterday
        Texts: {
          Ok: '선택',
          Clear: '지우기',
          Cancel: '취소',
          Today: '오늘',
          Yesterday: '어제',
          EmptyTip: '공백'
        },
      };

      if (Cal) { Cal.Close(); }
      Cal = IBSheet.showCalendar(optionCal, pos, callBack);
    } else if (btnObj.innerText === '특정기간내 선택') {
      optionCal = {
        Date: new Date(document.getElementById(btnObj.getAttribute('inp')).value || Date.UTC(2019, 2, 1, 3, 25, 45)),
        Buttons: 5, // 달력 밑에 나타날 버튼을 설정 1 - Today, 2 - Clear, 4 - Ok, 8 - Yesterday
        Texts: {
          Ok: '선택',
          Clear: '지우기',
          Cancel: '취소',
          Today: '오늘',
          Yesterday: '어제',
          EmptyTip: '공백'
        },
        OnCanEditDate: function (date) {
          // 3월 5일 ~ 3월 15일 사이만 선택 가능
          var startdate = new Date(Date.UTC(2019, 2, 4, 0, 0, 0));
          var enddate = new Date(Date.UTC(2019, 2, 15, 0, 0, 0));

          if (date < startdate || date > enddate) {
            return false;
          }
        }
      };

      if (Cal) { Cal.Close(); }
      Cal = IBSheet.showCalendar(optionCal, pos, callBack);
    } else if (btnObj.innerText === '특정일자표시') {
      if (document.getElementById(btnObj.getAttribute('inp')).value) {
        value = document.getElementById(btnObj.getAttribute('inp')).value.split(';').map(val => {
          if (val.indexOf('~')) {
            return val.split('~').map(val => { return new Date(val).getTime(); }).join('~');
          }

          return new Date(val).getTime();
        }).join(';');
      } else {
        value = new Date(Date.UTC(2019, 2, 1, 3, 25, 45));
      }

      optionCal = {
        Date: value,
        Range: 1,
        Buttons: 5, // 달력 밑에 나타날 버튼을 설정 1 - Today, 2 - Clear, 4 - Ok, 8 - Yesterday
        Texts: {
          Ok: '선택',
          Clear: '지우기',
          Cancel: '취소',
          Today: '오늘',
          Yesterday: '어제',
          EmptyTip: '공백'
        },
        OnGetCalendarDate: function (date, txt, classes, range) {
          console.log(date, txt, classes, range);
          // 매월 15일을 굵은 오렌지 색으로 표시
          if (date.getDate() === 15) {
            // css class명을 리턴
            return '<strong style=\'color:orange\'>' + txt + '</strong>';
          }

          return txt;
        }
      };

      if (Cal) { Cal.Close(); }
      Cal = IBSheet.showCalendar(optionCal, pos, callBack);
    }
  },

  // event구문
  event: {
    onReadCanEditDate: function (evtParam) {
      if (evtParam.col === 'DUE_DATE') {
        var row = evtParam.row;
        var startDate = new Date(parseInt(row.ORDER_DATE, 10));
        var endDate = new Date(parseInt(row.DTDY31, 10));

        // 수주일과 검수일 사이만 선택 가능함.
        if (evtParam.date < startDate || evtParam.date > endDate) {
          return false;
        }

        return true;
      }
    }
  },

  // data
  data: [
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030065-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'ENCORDER 납품',
      ORDER_DATE: '2003-10-09',
      DUE_DATE: '2003-10-09',
      DTDY31: '2003-10-25',
      NOCS31: 'AM814310-003-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030063-0',
      CUST_CD: 'DS0026',
      CUST_NM: '하림산업(주) 울산공장',
      ORDER_NM: '스톱 센서',
      ORDER_DATE: '2003-10-09',
      DUE_DATE: '2003-10-09',
      DTDY31: '2003-10-20',
      NOCS31: 'AM814309-004-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030062-0',
      CUST_CD: 'DS0024',
      CUST_NM: '대성페인트(주) 광주공장',
      ORDER_NM: '램런 인버터 납품',
      ORDER_DATE: '2003-10-09',
      DUE_DATE: '2003-10-09',
      DTDY31: '2003-10-20',
      NOCS31: 'AM814309-003-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030061-0',
      CUST_CD: 'DS0032',
      CUST_NM: '대농(주) 부산공장',
      ORDER_NM: '램런 부품',
      ORDER_DATE: '2003-10-09',
      DUE_DATE: '2003-10-09',
      DTDY31: '2003-12-08',
      NOCS31: 'AM814310-007-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030068-0',
      CUST_CD: 'DS0024',
      CUST_NM: '대성페인트(주) 광주공장',
      ORDER_NM: '파워트롤리 & 집전자 납품',
      ORDER_DATE: '2003-10-07',
      DUE_DATE: '2003-10-07',
      DTDY31: '2003-10-20',
      NOCS31: 'AM814310-008-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030060-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'PBS STOPPER 추가공사',
      ORDER_DATE: '2003-09-16',
      DUE_DATE: '2003-09-16',
      DTDY31: '2003-11-10',
      NOCS31: 'AM814310-001-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030059-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'HA-2 FEM 투입공정 RAIL LEVEL 조정작업',
      ORDER_DATE: '2003-08-26',
      DUE_DATE: '2003-08-26',
      DTDY31: '2003-09-15',
      NOCS31: 'AM814308-007-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030058-0',
      CUST_CD: 'DA1515',
      CUST_NM: '미유 CORP(주) ',
      ORDER_NM: 'BIW 운반장치 및 SLAT CONVEYOR 공사',
      ORDER_DATE: '2003-08-26',
      DUE_DATE: '2003-08-26',
      DTDY31: '2004-02-28',
      NOCS31: 'AM814308-006-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030057-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'SRT 기판 납품',
      ORDER_DATE: '2003-08-20',
      DUE_DATE: '2003-08-20',
      DTDY31: '2003-10-31',
      NOCS31: 'AM814308-004-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030056-0',
      CUST_CD: 'DS0023',
      CUST_NM: '대성페인트(주) 경산 공장',
      ORDER_NM: 'C/V CHAIN 납품',
      ORDER_DATE: '2003-08-18',
      DUE_DATE: '2003-08-18',
      DTDY31: '2003-09-15',
      NOCS31: 'AM814307-012-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030055-0',
      CUST_CD: 'DS0025',
      CUST_NM: '하림산업(주) 아산공장',
      ORDER_NM: 'CHASSIS HANGER 투입공사',
      ORDER_DATE: '2003-08-18',
      DUE_DATE: '2003-08-18',
      DTDY31: '2003-09-14',
      NOCS31: 'AM814308-002-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030054-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'SD EMS 전차교체 및 개조',
      ORDER_DATE: '2003-08-18',
      DUE_DATE: '2003-08-18',
      DTDY31: '2003-10-13',
      NOCS31: 'AM814308-003-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030049-0',
      CUST_CD: 'DA1514',
      CUST_NM: '흥해산업(주)',
      ORDER_NM: '조립공장 설치공사 추가분 - Ⅲ',
      ORDER_DATE: '2003-07-28',
      DUE_DATE: '2003-07-28',
      DTDY31: '2003-07-28',
      NOCS31: 'AM814307-022-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030047-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '실러장 설치공사',
      ORDER_DATE: '2003-07-23',
      DUE_DATE: '2003-07-23',
      DTDY31: '2003-09-14',
      NOCS31: 'AM814307-016-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030046-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '차체 2공장 램런 인버터 납품',
      ORDER_DATE: '2003-07-11',
      DUE_DATE: '2003-07-11',
      DTDY31: '2003-07-11',
      NOCS31: 'AM814307-011-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030045-0',
      CUST_CD: 'DA1513',
      CUST_NM: '세진산업',
      ORDER_NM: 'A01014 수주번호 대체건',
      ORDER_DATE: '2003-07-07',
      DUE_DATE: '2003-07-07',
      DTDY31: '2003-07-07',
      NOCS31: 'AM814307-006-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030043-0',
      CUST_CD: 'DA1517',
      CUST_NM: '(주)일원',
      ORDER_NM: 'C030007 PU-PAINT SHOP 관련 기타경비 청구건',
      ORDER_DATE: '2003-07-07',
      DUE_DATE: '2003-07-07',
      DTDY31: '2003-07-07',
      NOCS31: 'AM814307-023-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030044-0',
      CUST_CD: 'DA1514',
      CUST_NM: '흥해산업(주)',
      ORDER_NM: '조립공장 설치공사 추가분',
      ORDER_DATE: '2003-07-04',
      DUE_DATE: '2003-07-04',
      DTDY31: '2003-07-05',
      NOCS31: 'AM814307-007-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030042-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'JX-458 CHAIN 납품',
      ORDER_DATE: '2003-07-04',
      DUE_DATE: '2003-07-04',
      DTDY31: '2003-07-30',
      NOCS31: 'AM814307-009-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030041-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '공대차 회송 LINE 설치공사',
      ORDER_DATE: '2003-07-04',
      DUE_DATE: '2003-07-04',
      DTDY31: '2003-09-25',
      NOCS31: 'AM814307-003-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030040-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'BLACK WAX LINE 설치공사',
      ORDER_DATE: '2003-07-04',
      DUE_DATE: '2003-07-04',
      DTDY31: '2003-08-20',
      NOCS31: 'AM814307-004-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030039-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'PBS SUN ROOF 작업공정 신설공사',
      ORDER_DATE: '2003-07-04',
      DUE_DATE: '2003-07-04',
      DTDY31: '2003-08-04',
      NOCS31: 'AM814307-002-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030038-0',
      CUST_CD: 'DA1514',
      CUST_NM: '흥해산업(주)',
      ORDER_NM: '조립공장 설치공사 추가분',
      ORDER_DATE: '2003-06-13',
      DUE_DATE: '2003-06-13',
      DTDY31: '2003-06-20',
      NOCS31: 'AM814306-005-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030037-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '램런용 인버터 납품건',
      ORDER_DATE: '2003-05-29',
      DUE_DATE: '2003-05-29',
      DTDY31: '2003-08-30',
      NOCS31: 'AM814306-001-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030036-0',
      CUST_CD: 'DS0032',
      CUST_NM: '대농(주) 부산공장',
      ORDER_NM: 'ENGINE LINE DOCKING 구간 설치공사',
      ORDER_DATE: '2003-05-15',
      DUE_DATE: '2003-05-15',
      DTDY31: '2003-08-03',
      NOCS31: 'AM814304-012-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030035-0',
      CUST_CD: 'DS0032',
      CUST_NM: '대농(주) 부산공장',
      ORDER_NM: 'MAIN LINE ATTACH\' 공용화',
      ORDER_DATE: '2003-05-15',
      DUE_DATE: '2003-05-15',
      DTDY31: '2003-09-30',
      NOCS31: 'AM814304-011-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030033-0',
      CUST_CD: 'DS0023',
      CUST_NM: '대성페인트(주) 경산 공장',
      ORDER_NM: '카터필러체인 납품건',
      ORDER_DATE: '2003-05-15',
      DUE_DATE: '2003-05-15',
      DTDY31: '2003-07-30',
      NOCS31: 'AM814305-002-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030034-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'SUB C/V CHAIN ASS\'Y 납품',
      ORDER_DATE: '2003-05-13',
      DUE_DATE: '2003-05-13',
      DTDY31: '2003-07-30',
      NOCS31: 'AM814305-003-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030032-0',
      CUST_CD: 'DS0032',
      CUST_NM: '대농(주) 부산공장',
      ORDER_NM: 'EX BODY SHOP 설치공사',
      ORDER_DATE: '2003-05-01',
      DUE_DATE: '2003-05-01',
      DTDY31: '2003-09-25',
      NOCS31: 'AM814305-001-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030031-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '사이드아웃터운반장치신작',
      ORDER_DATE: '2003-04-28',
      DUE_DATE: '2003-04-28',
      DTDY31: '2003-08-04',
      NOCS31: 'AM814304-010-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030030-0',
      CUST_CD: 'DS0032',
      CUST_NM: '대농(주) 부산공장',
      ORDER_NM: 'BLOWER MOTOR 납품',
      ORDER_DATE: '2003-04-21',
      DUE_DATE: '2003-04-21',
      DTDY31: '2003-08-21',
      NOCS31: 'AM814304-008-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030029-0',
      CUST_CD: 'DA1516',
      CUST_NM: '(주)라피드F',
      ORDER_NM: '수주 변경건',
      ORDER_DATE: '2003-04-17',
      DUE_DATE: '2003-04-17',
      DTDY31: '2003-04-17',
      NOCS31: 'AM814304-005-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030028-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'JX-458 CHAIN 납품',
      ORDER_DATE: '2003-04-17',
      DUE_DATE: '2003-04-17',
      DTDY31: '2003-04-25',
      NOCS31: 'AM814304-006-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030027-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'BL 차체 20만대 대응 (2단계 공사)',
      ORDER_DATE: '2003-04-14',
      DUE_DATE: '2003-04-14',
      DTDY31: '2003-08-03',
      NOCS31: 'AM814304-007-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030024-0',
      CUST_CD: 'DS0024',
      CUST_NM: '대성페인트(주) 광주공장',
      ORDER_NM: 'PU PAINT PBS 신설공사',
      ORDER_DATE: '2003-03-25',
      DUE_DATE: '2003-03-25',
      DTDY31: '2003-06-30',
      NOCS31: 'AM814304-002-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030023-0',
      CUST_CD: 'DS0023',
      CUST_NM: '대성페인트(주) 경산 공장',
      ORDER_NM: '소하리 전차반 수리건',
      ORDER_DATE: '2003-03-24',
      DUE_DATE: '2003-03-24',
      DTDY31: '2003-06-30',
      NOCS31: 'AM814304-001-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030021-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '쎈터링플로팅플레이트앗세이 납품',
      ORDER_DATE: '2003-03-15',
      DUE_DATE: '2003-03-15',
      DTDY31: '2003-04-05',
      NOCS31: 'AM814303-001-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030020-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '마이너 리페어 라인 신설공사',
      ORDER_DATE: '2003-02-19',
      DUE_DATE: '2003-02-19',
      DTDY31: '2003-03-31',
      NOCS31: 'AM814302-010-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030019-1',
      CUST_CD: 'DS0034',
      CUST_NM: '지구개발-수원',
      ORDER_NM: 'M200 PJT 조립공장 CONVEYOR 공사',
      ORDER_DATE: '2003-02-07',
      DUE_DATE: '2003-02-07',
      DTDY31: '2003-06-14',
      NOCS31: 'AM814302-002-01',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030019-0',
      CUST_CD: 'DS0034',
      CUST_NM: '지구개발-수원',
      ORDER_NM: 'M200 PJT 조립공장 CONVEYOR 공사',
      ORDER_DATE: '2003-02-07',
      DUE_DATE: '2003-02-07',
      DTDY31: '2003-06-14',
      NOCS31: 'AM814302-002-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030018-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'MAIN LINE ANTIRUN C/V 신설',
      ORDER_DATE: '2003-02-06',
      DUE_DATE: '2003-02-06',
      DTDY31: '2003-03-30',
      NOCS31: 'AM814302-003-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030017-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '카터필러체인 납품',
      ORDER_DATE: '2003-01-28',
      DUE_DATE: '2003-01-28',
      DTDY31: '2003-02-20',
      NOCS31: 'AM814302-009-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030016-0',
      CUST_CD: 'DS0023',
      CUST_NM: '대성페인트(주) 경산 공장',
      ORDER_NM: '카터필러체인 납품',
      ORDER_DATE: '2003-01-28',
      DUE_DATE: '2003-01-28',
      DTDY31: '2003-02-14',
      NOCS31: 'AM814306-003-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030015-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '램런용 인버터 납품',
      ORDER_DATE: '2003-01-28',
      DUE_DATE: '2003-01-28',
      DTDY31: '2003-02-20',
      NOCS31: 'AM814302-007-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030014-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'HA-2 PBS 이재장치 설치공사',
      ORDER_DATE: '2003-01-20',
      DUE_DATE: '2003-01-20',
      DTDY31: '2003-02-10',
      NOCS31: 'AM814302-001-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030013-0',
      CUST_CD: 'DS0032',
      CUST_NM: '대농(주) 부산공장',
      ORDER_NM: 'SYNCHRONIZER 납품',
      ORDER_DATE: '2003-01-20',
      DUE_DATE: '2003-01-20',
      DTDY31: '2003-02-28',
      NOCS31: 'AM814302-005-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030012-0',
      CUST_CD: 'DS0026',
      CUST_NM: '하림산업(주) 울산공장',
      ORDER_NM: '차체공장 TB라인 전차 투입건',
      ORDER_DATE: '2003-01-16',
      DUE_DATE: '2003-01-16',
      DTDY31: '2003-03-31',
      NOCS31: 'AM814302-004-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030010-0',
      CUST_CD: 'DS0026',
      CUST_NM: '하림산업(주) 울산공장',
      ORDER_NM: '레일청소장치(부스바레일)',
      ORDER_DATE: '2003-01-03',
      DUE_DATE: '2003-01-03',
      DTDY31: '2003-01-10',
      NOCS31: 'AM814301-003-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030008-0',
      CUST_CD: 'DS0034',
      CUST_NM: '지구개발-수원',
      ORDER_NM: 'M200 차체공장 C/V공사',
      ORDER_DATE: '2003-01-03',
      DUE_DATE: '2003-01-03',
      DTDY31: '2003-06-10',
      NOCS31: 'AM814301-006-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030011-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'DOOR LINE 판넬 이설건',
      ORDER_DATE: '2003-01-02',
      DUE_DATE: '2003-01-02',
      DTDY31: '2003-01-12',
      NOCS31: 'AM814212-009-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030007-0',
      CUST_CD: 'DS0024',
      CUST_NM: '대성페인트(주) 광주공장',
      ORDER_NM: 'PU-PAINT SHOP 신설공사',
      ORDER_DATE: '2003-01-02',
      DUE_DATE: '2003-01-02',
      DTDY31: '2003-06-30',
      NOCS31: 'AM814301-005-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030006-0',
      CUST_CD: 'DS0024',
      CUST_NM: '대성페인트(주) 광주공장',
      ORDER_NM: 'PU-BODY SHOP 신설공사',
      ORDER_DATE: '2003-01-02',
      DUE_DATE: '2003-01-02',
      DTDY31: '2003-06-30',
      NOCS31: 'AM814301-004-00',
      ORDER_CLOSE_YN: '0'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030005-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '차체공장 CRP대차 1차 CARRIER',
      ORDER_DATE: '2003-01-02',
      DUE_DATE: '2003-01-02',
      DTDY31: '2003-03-10',
      NOCS31: 'AM814301-002-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030004-0',
      CUST_CD: 'DA1515',
      CUST_NM: '미유 CORP(주) ',
      ORDER_NM: '조립공장 A-100 개조.신설공사',
      ORDER_DATE: '2003-01-02',
      DUE_DATE: '2003-01-02',
      DTDY31: '2003-08-30',
      NOCS31: 'AM814210-014-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030003-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'HA-2 DOOR LINE 장착구간 이설',
      ORDER_DATE: '2003-01-02',
      DUE_DATE: '2003-01-02',
      DTDY31: '2003-02-28',
      NOCS31: 'AM814212-006-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C030002-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'PRE TRIM 저속 LINE 연장 설치공사',
      ORDER_DATE: '2003-01-02',
      DUE_DATE: '2003-01-02',
      DTDY31: '2003-02-28',
      NOCS31: 'AM814212-005-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020032-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'HA-2 CHASSIS LINE 하체공정 신설공사 <A02103>',
      ORDER_DATE: '2002-12-26',
      DUE_DATE: '2002-12-26',
      DTDY31: '2003-02-28',
      NOCS31: 'AM814212-004-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020031-0',
      CUST_CD: 'DA1514',
      CUST_NM: '흥해산업(주)',
      ORDER_NM: '조립공장 설치공사 <A02102>',
      ORDER_DATE: '2002-12-23',
      DUE_DATE: '2002-12-23',
      DTDY31: '2003-03-31',
      NOCS31: 'AM814212-007-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020029-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'HA-2 엔진탈장착 테이블리프트 록장치 <A02100>',
      ORDER_DATE: '2002-12-05',
      DUE_DATE: '2002-12-05',
      DTDY31: '2002-12-30',
      NOCS31: 'AM814212-001-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020028-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '3도공장 UNDERCOAT HANGER REAR ATT\'H 외 2건 <A02099>',
      ORDER_DATE: '2002-12-05',
      DUE_DATE: '2002-12-05',
      DTDY31: '2002-12-30',
      NOCS31: 'AM814212-002-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020027-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'PRE TRIM 저속라인 연장 설치공사 <A02098>',
      ORDER_DATE: '2002-11-27',
      DUE_DATE: '2002-11-27',
      DTDY31: '2003-01-03',
      NOCS31: 'AM814211-016-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020026-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'HA-2 PBS BODY 이재장치 설치공사 <A02097>',
      ORDER_DATE: '2002-11-27',
      DUE_DATE: '2002-11-27',
      DTDY31: '2003-02-28',
      NOCS31: 'AM814211-015-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020025-0',
      CUST_CD: 'DS0023',
      CUST_NM: '대성페인트(주) 경산 공장',
      ORDER_NM: 'B-3 CHASSIS LINE 설치공사 <A02096>',
      ORDER_DATE: '2002-11-27',
      DUE_DATE: '2002-11-27',
      DTDY31: '2002-11-30',
      NOCS31: 'AM814211-014-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020024-0',
      CUST_CD: 'DS0023',
      CUST_NM: '대성페인트(주) 경산 공장',
      ORDER_NM: 'B-3 CHASSIS LINE 설치공사 <A02096>',
      ORDER_DATE: '2002-11-27',
      DUE_DATE: '2002-11-27',
      DTDY31: '2002-11-30',
      NOCS31: 'AM814211-014-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020009-0',
      CUST_CD: 'DS0026',
      CUST_NM: '하림산업(주) 울산공장',
      ORDER_NM: '레일청소장치(보전4부)',
      ORDER_DATE: '2002-11-08',
      DUE_DATE: '2002-11-08',
      DTDY31: '2002-11-20',
      NOCS31: 'AM814211-005-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020008-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'HA-2 ROOF RACK 작업공정 신설공사 <A02082>',
      ORDER_DATE: '2002-11-08',
      DUE_DATE: '2002-11-08',
      DTDY31: '2002-11-30',
      NOCS31: 'AM814209-001-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020007-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'DOOR HANGER 납품 <A02081>',
      ORDER_DATE: '2002-11-08',
      DUE_DATE: '2002-11-08',
      DTDY31: '2002-12-30',
      NOCS31: 'AM814210-004-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020006-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '운반설비 전차반 TROLLEY ASS\'Y <A02079>',
      ORDER_DATE: '2002-11-08',
      DUE_DATE: '2002-11-08',
      DTDY31: '2002-12-20',
      NOCS31: 'AM814211-004-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020004-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: '전처리라인 C/V RAIL 교체공사(A02077)',
      ORDER_DATE: '2002-10-11',
      DUE_DATE: '2002-10-11',
      DTDY31: '2002-12-30',
      NOCS31: 'AM814207-001-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020003-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'BL-BODY 20만대 대응공사(A02076)',
      ORDER_DATE: '2002-10-11',
      DUE_DATE: '2002-10-11',
      DTDY31: '2002-12-30',
      NOCS31: 'AM814210-003-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020002-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'SIDE & CRP LINE 설치공사(A02075)',
      ORDER_DATE: '2002-10-11',
      DUE_DATE: '2002-10-11',
      DTDY31: '2003-01-30',
      NOCS31: 'AM814210-002-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C020001-0',
      CUST_CD: 'DS0032',
      CUST_NM: '대농(주) 부산공장',
      ORDER_NM: '조립공장 TRIM-D,B LINE CONVEYOR 설치공사(A02074)',
      ORDER_DATE: '2002-10-10',
      DUE_DATE: '2002-10-10',
      DTDY31: '2002-10-30',
      NOCS31: 'AM814210-001-00',
      ORDER_CLOSE_YN: '1'
    },
    {
      DIV_CD: '100',
      ORDER_NUM: 'C000001-0',
      CUST_CD: 'DS0022',
      CUST_NM: '대성페인트(주) 창원',
      ORDER_NM: 'HB-5 W.B.S TACK UP개조외(A20026)',
      ORDER_DATE: '2000-08-19',
      DUE_DATE: '2000-08-19',
      DTDY31: '2001-01-10',
      NOCS31: 'AM814008-001-00',
      ORDER_CLOSE_YN: '1'
    }
  ]

};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
